﻿using System;

namespace VIRP.EFR.BO
{
    [Serializable]
    public class LabResultInterpetation : IEquatable<LabResultInterpetation>
    {
        public DateTime AcceptedDate { get; set; }
        public int CaseId { get; set; }
        public int ActivityId { get; set; }
        public string PatientName { get; set; }
        public string StationNumber { get; set; }
        public string Institution { get; set; }
        public int CaseTypeId { get; set; }
        public string CaseType { get; set; }
        public int IntActivityId { get; set; }

        public bool Equals(LabResultInterpetation other)
        {
            return this.ActivityId == other.ActivityId;
        }

        public override bool Equals(object other)
        {
            LabResultInterpetation otherSpecific = other as LabResultInterpetation;

            return otherSpecific != null && this.ActivityId == otherSpecific.ActivityId;
        }

        public override int GetHashCode()
        {
            return this.ActivityId.GetHashCode();
        }
    } 
}
